/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.intercompatibility.CommonCompatibilityManager;
import de.maxhenkel.voicechat.intercompatibility.CrossSideManager;
import de.maxhenkel.voicechat.net.NetManager;
import de.maxhenkel.voicechat.net.SecretPacket;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.common.Secret;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_3176;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ServerVoiceEvents {
    private final Map<UUID, Integer> clientCompatibilities = new ConcurrentHashMap<UUID, Integer>();
    private Server server;

    public ServerVoiceEvents() {
        CommonCompatibilityManager.INSTANCE.onServerStarting(this::serverStarting);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedIn(this::playerLoggedIn);
        CommonCompatibilityManager.INSTANCE.onPlayerLoggedOut(this::playerLoggedOut);
        CommonCompatibilityManager.INSTANCE.onPlayerHide(this::onPlayerHide);
        CommonCompatibilityManager.INSTANCE.onPlayerShow(this::onPlayerShow);
        CommonCompatibilityManager.INSTANCE.onServerStopping(this::serverStopping);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatConnected(this::serverVoiceChatConnected);
        CommonCompatibilityManager.INSTANCE.onServerVoiceChatDisconnected(this::serverVoiceChatDisconnected);
        CommonCompatibilityManager.INSTANCE.onPlayerCompatibilityCheckSucceeded(this::playerCompatibilityCheckSucceeded);
        CommonCompatibilityManager.INSTANCE.getNetManager().requestSecretChannel.setServerListener((player, packet) -> {
            Voicechat.LOGGER.info("Received secret request of {} ({})", player.method_5477().getString(), packet.getCompatibilityVersion());
            this.clientCompatibilities.put(player.method_5667(), packet.getCompatibilityVersion());
            if (packet.getCompatibilityVersion() != Voicechat.COMPATIBILITY_VERSION) {
                Voicechat.LOGGER.warn("Connected client {} has incompatible voice chat version (server={}, client={})", player.method_5477().getString(), Voicechat.COMPATIBILITY_VERSION, packet.getCompatibilityVersion());
                player.method_64398(this.getIncompatibleMessage(packet.getCompatibilityVersion()));
            } else {
                this.initializePlayerConnection(player);
            }
        });
    }

    public class_2561 getIncompatibleMessage(int clientCompatibilityVersion) {
        if (clientCompatibilityVersion <= 6) {
            return class_2561.method_43470((String)Voicechat.TRANSLATIONS.voicechatNotCompatibleMessage.get().formatted("2.6.x", CommonCompatibilityManager.INSTANCE.getModName()));
        }
        return class_2561.method_48322((String)"message.voicechat.incompatible_version", (String)"Your voice chat client version is not compatible with the server-side version.\nPlease install version %s of %s.", (Object[])new Object[]{class_2561.method_43470((String)"2.6.x").method_27692(class_124.field_1067), class_2561.method_43470((String)CommonCompatibilityManager.INSTANCE.getModName()).method_27692(class_124.field_1067)});
    }

    public boolean isCompatible(class_3222 player) {
        return this.isCompatible(player.method_5667());
    }

    public boolean isCompatible(UUID playerUuid) {
        return this.clientCompatibilities.getOrDefault(playerUuid, -1) == Voicechat.COMPATIBILITY_VERSION;
    }

    public void serverStarting(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
        if (!CrossSideManager.get().shouldRunVoiceChatServer(mcServer)) {
            Voicechat.LOGGER.info("Disabling voice chat in singleplayer", new Object[0]);
            return;
        }
        if (mcServer instanceof class_3176 && !mcServer.method_3828()) {
            Voicechat.LOGGER.warn("Running in offline mode - Voice chat encryption is not secure!", new Object[0]);
        }
        try {
            this.server = new Server(mcServer);
            this.server.start();
            PluginManager.instance().onServerStarted();
        }
        catch (Exception e) {
            Voicechat.LOGGER.error("Failed to start voice chat server", e);
        }
    }

    public void initializePlayerConnection(class_3222 player) {
        if (this.server == null) {
            return;
        }
        CommonCompatibilityManager.INSTANCE.emitPlayerCompatibilityCheckSucceeded(player);
        Secret secret = this.server.generateNewSecret(player.method_5667());
        if (secret == null) {
            Voicechat.LOGGER.warn("Player already requested secret - ignoring", new Object[0]);
            return;
        }
        NetManager.sendToClient(player, new SecretPacket(player, secret, this.server.getPort(), Voicechat.SERVER_CONFIG));
        Voicechat.LOGGER.info("Sent secret to {}", player.method_5477().getString());
    }

    public void playerLoggedIn(final class_3222 serverPlayer) {
        if (this.server != null) {
            this.server.onPlayerLoggedIn(serverPlayer);
        }
        if (!Voicechat.SERVER_CONFIG.forceVoiceChat.get().booleanValue()) {
            return;
        }
        final Timer timer = new Timer("%s-login-timer".formatted(serverPlayer.method_7334().getName()), true);
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                timer.cancel();
                timer.purge();
                if (!serverPlayer.field_13995.method_3806()) {
                    return;
                }
                if (!serverPlayer.field_13987.method_48106()) {
                    return;
                }
                if (!ServerVoiceEvents.this.isCompatible(serverPlayer)) {
                    CommonCompatibilityManager.INSTANCE.execute(serverPlayer.field_13995, () -> serverPlayer2.field_13987.method_52396((class_2561)class_2561.method_43470((String)Voicechat.TRANSLATIONS.forceVoicechatKickMessage.get().formatted(CommonCompatibilityManager.INSTANCE.getModName(), CommonCompatibilityManager.INSTANCE.getModVersion()))));
                }
            }
        }, Voicechat.SERVER_CONFIG.loginTimeout.get().intValue());
    }

    public void playerLoggedOut(class_3222 player) {
        this.clientCompatibilities.remove(player.method_5667());
        if (this.server == null) {
            return;
        }
        this.server.onPlayerLoggedOut(player);
        Voicechat.LOGGER.info("Disconnecting client {}", player.method_5477().getString());
    }

    public void onPlayerHide(class_3222 visibilityChangedPlayer, class_3222 observingPlayer) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerHide(visibilityChangedPlayer, observingPlayer);
    }

    public void onPlayerShow(class_3222 visibilityChangedPlayer, class_3222 observingPlayer) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerShow(visibilityChangedPlayer, observingPlayer);
    }

    public void serverVoiceChatConnected(class_3222 serverPlayer) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerVoicechatConnect(serverPlayer);
    }

    public void serverVoiceChatDisconnected(UUID uuid) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerVoicechatDisconnect(uuid);
    }

    public void playerCompatibilityCheckSucceeded(class_3222 player) {
        if (this.server == null) {
            return;
        }
        this.server.onPlayerCompatibilityCheckSucceeded(player);
    }

    @Nullable
    public Server getServer() {
        return this.server;
    }

    public void serverStopping(MinecraftServer mcServer) {
        if (this.server != null) {
            this.server.close();
            this.server = null;
        }
    }
}

